<?php
/**
 * Copyright (c) Meta Platforms, Inc. and affiliates. All Rights Reserved
 */

namespace Facebook\BusinessExtension\Model\Config\Source\Product;

use Magento\Eav\Model\Entity\Attribute\Source\AbstractSource;

class GoogleProductCategory extends AbstractSource
{
    /**
     * Get all options
     *
     * @return array
     */
    public function getAllOptions()
    {
        if ($this->_options === null) {
            $this->_options = [
                ['value' => '', 'label' => __('Please Select')],
                ['value' => 'Animals & Pet Supplies', 'label' => __('Animals & Pet Supplies')],
                ['value' => 'Animals & Pet Supplies > Live Animals',
                    'label' => __('Animals & Pet Supplies > Live Animals')],
                ['value' => 'Animals & Pet Supplies > Pet Supplies',
                    'label' => __('Animals & Pet Supplies > Pet Supplies')],
                ['value' => 'Apparel & Accessories', 'label' => __('Apparel & Accessories')],
                ['value' => 'Apparel & Accessories > Clothing', 'label' => __('Apparel & Accessories > Clothing')],
                ['value' => 'Apparel & Accessories > Clothing Accessories',
                    'label' => __('Apparel & Accessories > Clothing Accessories')],
                ['value' => 'Apparel & Accessories > Costumes & Accessories',
                    'label' => __('Apparel & Accessories > Costumes & Accessories')],
                ['value' => 'Apparel & Accessories > Handbag & Wallet Accessories',
                    'label' => __('Apparel & Accessories > Handbag & Wallet Accessories')],
                ['value' => 'Apparel & Accessories > Handbags, Wallets & Cases',
                    'label' => __('Apparel & Accessories > Handbags, Wallets & Cases')],
                ['value' => 'Apparel & Accessories > Jewelry', 'label' => __('Apparel & Accessories > Jewelry')],
                ['value' => 'Apparel & Accessories > Shoe Accessories',
                    'label' => __('Apparel & Accessories > Shoe Accessories')],
                ['value' => 'Apparel & Accessories > Shoes', 'label' => __('Apparel & Accessories > Shoes')],
                ['value' => 'Arts & Entertainment', 'label' => __('Arts & Entertainment')],
                ['value' => 'Arts & Entertainment > Event Tickets',
                    'label' => __('Arts & Entertainment > Event Tickets')],
                ['value' => 'Arts & Entertainment > Hobbies & Creative Arts',
                    'label' => __('Arts & Entertainment > Hobbies & Creative Arts')],
                ['value' => 'Arts & Entertainment > Party & Celebration',
                    'label' => __('Arts & Entertainment > Party & Celebration')],
                ['value' => 'Baby & Toddler', 'label' => __('Baby & Toddler')],
                ['value' => 'Baby & Toddler > Baby Bathing', 'label' => __('Baby & Toddler > Baby Bathing')],
                ['value' => 'Baby & Toddler > Baby Gift Sets', 'label' => __('Baby & Toddler > Baby Gift Sets')],
                ['value' => 'Baby & Toddler > Baby Health', 'label' => __('Baby & Toddler > Baby Health')],
                ['value' => 'Baby & Toddler > Baby Safety', 'label' => __('Baby & Toddler > Baby Safety')],
                ['value' => 'Baby & Toddler > Baby Toys & Activity Equipment',
                    'label' => __('Baby & Toddler > Baby Toys & Activity Equipment')],
                ['value' => 'Baby & Toddler > Baby Transport', 'label' => __('Baby & Toddler > Baby Transport')],
                ['value' => 'Baby & Toddler > Baby Transport Accessories',
                    'label' => __('Baby & Toddler > Baby Transport Accessories')],
                ['value' => 'Baby & Toddler > Diapering', 'label' => __('Baby & Toddler > Diapering')],
                ['value' => 'Baby & Toddler > Nursing & Feeding', 'label' => __('Baby & Toddler > Nursing & Feeding')],
                ['value' => 'Baby & Toddler > Potty Training', 'label' => __('Baby & Toddler > Potty Training')],
                ['value' => 'Baby & Toddler > Swaddling & Receiving Blankets',
                    'label' => __('Baby & Toddler > Swaddling & Receiving Blankets')],
                ['value' => 'Business & Industrial', 'label' => __('Business & Industrial')],
                ['value' => 'Business & Industrial > Advertising & Marketing',
                    'label' => __('Business & Industrial > Advertising & Marketing')],
                ['value' => 'Business & Industrial > Agriculture',
                    'label' => __('Business & Industrial > Agriculture')],
                ['value' => 'Business & Industrial > Automation Control Components',
                    'label' => __('Business & Industrial > Automation Control Components')],
                ['value' => 'Business & Industrial > Construction',
                    'label' => __('Business & Industrial > Construction')],
                ['value' => 'Business & Industrial > Dentistry',
                    'label' => __('Business & Industrial > Dentistry')],
                ['value' => 'Business & Industrial > Film & Television',
                    'label' => __('Business & Industrial > Film & Television')],
                ['value' => 'Business & Industrial > Finance & Insurance',
                    'label' => __('Business & Industrial > Finance & Insurance')],
                ['value' => 'Business & Industrial > Food Service',
                    'label' => __('Business & Industrial > Food Service')],
                ['value' => 'Business & Industrial > Forestry & Logging',
                    'label' => __('Business & Industrial > Forestry & Logging')],
                ['value' => 'Business & Industrial > Hairdressing & Cosmetology',
                    'label' => __('Business & Industrial > Hairdressing & Cosmetology')],
                ['value' => 'Business & Industrial > Heavy Machinery',
                    'label' => __('Business & Industrial > Heavy Machinery')],
                ['value' => 'Business & Industrial > Hotel & Hospitality',
                    'label' => __('Business & Industrial > Hotel & Hospitality')],
                ['value' => 'Business & Industrial > Industrial Storage',
                    'label' => __('Business & Industrial > Industrial Storage')],
                ['value' => 'Business & Industrial > Industrial Storage Accessories',
                    'label' => __('Business & Industrial > Industrial Storage Accessories')],
                ['value' => 'Business & Industrial > Janitorial Carts & Caddies',
                    'label' => __('Business & Industrial > Janitorial Carts & Caddies')],
                ['value' => 'Business & Industrial > Law Enforcement',
                    'label' => __('Business & Industrial > Law Enforcement')],
                ['value' => 'Business & Industrial > Manufacturing',
                    'label' => __('Business & Industrial > Manufacturing')],
                ['value' => 'Business & Industrial > Material Handling',
                    'label' => __('Business & Industrial > Material Handling')],
                ['value' => 'Business & Industrial > Medical', 'label' => __('Business & Industrial > Medical')],
                ['value' => 'Business & Industrial > Mining & Quarrying',
                    'label' => __('Business & Industrial > Mining & Quarrying')],
                ['value' => 'Business & Industrial > Piercing & Tattooing',
                    'label' => __('Business & Industrial > Piercing & Tattooing')],
                ['value' => 'Business & Industrial > Retail', 'label' => __('Business & Industrial > Retail')],
                ['value' => 'Business & Industrial > Science & Laboratory',
                    'label' => __('Business & Industrial > Science & Laboratory')],
                ['value' => 'Business & Industrial > Signage', 'label' => __('Business & Industrial > Signage')],
                ['value' => 'Business & Industrial > Work Safety Protective Gear',
                    'label' => __('Business & Industrial > Work Safety Protective Gear')],
                ['value' => 'Cameras & Optics', 'label' => __('Cameras & Optics')],
                ['value' => 'Cameras & Optics > Camera & Optic Accessories',
                    'label' => __('Cameras & Optics > Camera & Optic Accessories')],
                ['value' => 'Cameras & Optics > Cameras', 'label' => __('Cameras & Optics > Cameras')],
                ['value' => 'Cameras & Optics > Optics', 'label' => __('Cameras & Optics > Optics')],
                ['value' => 'Cameras & Optics > Photography', 'label' => __('Cameras & Optics > Photography')],
                ['value' => 'Electronics', 'label' => __('Electronics')],
                ['value' => 'Electronics > Arcade Equipment', 'label' => __('Electronics > Arcade Equipment')],
                ['value' => 'Electronics > Audio', 'label' => __('Electronics > Audio')],
                ['value' => 'Electronics > Circuit Boards & Components',
                    'label' => __('Electronics > Circuit Boards & Components')],
                ['value' => 'Electronics > Communications', 'label' => __('Electronics > Communications')],
                ['value' => 'Electronics > Components', 'label' => __('Electronics > Components')],
                ['value' => 'Electronics > Computers', 'label' => __('Electronics > Computers')],
                ['value' => 'Electronics > Electronics Accessories',
                    'label' => __('Electronics > Electronics Accessories')],
                ['value' => 'Electronics > GPS Accessories', 'label' => __('Electronics > GPS Accessories')],
                ['value' => 'Electronics > GPS Navigation Systems',
                    'label' => __('Electronics > GPS Navigation Systems')],
                ['value' => 'Electronics > GPS Tracking Devices', 'label' => __('Electronics > GPS Tracking Devices')],
                ['value' => 'Electronics > Marine Electronics', 'label' => __('Electronics > Marine Electronics')],
                ['value' => 'Electronics > Networking', 'label' => __('Electronics > Networking')],
                ['value' => 'Electronics > Print, Copy, Scan & Fax',
                    'label' => __('Electronics > Print, Copy, Scan & Fax')],
                ['value' => 'Electronics > Radar Detectors', 'label' => __('Electronics > Radar Detectors')],
                ['value' => 'Electronics > Speed Radars', 'label' => __('Electronics > Speed Radars')],
                ['value' => 'Electronics > Toll Collection Devices',
                    'label' => __('Electronics > Toll Collection Devices')],
                ['value' => 'Electronics > Video', 'label' => __('Electronics > Video')],
                ['value' => 'Electronics > Video Game Console Accessories',
                    'label' => __('Electronics > Video Game Console Accessories')],
                ['value' => 'Electronics > Video Game Consoles', 'label' => __('Electronics > Video Game Consoles')],
                ['value' => 'Food, Beverages & Tobacco', 'label' => __('Food, Beverages & Tobacco')],
                ['value' => 'Food, Beverages & Tobacco > Beverages',
                    'label' => __('Food, Beverages & Tobacco > Beverages')],
                ['value' => 'Food, Beverages & Tobacco > Food Items',
                    'label' => __('Food, Beverages & Tobacco > Food Items')],
                ['value' => 'Food, Beverages & Tobacco > Tobacco Products',
                    'label' => __('Food, Beverages & Tobacco > Tobacco Products')],
                ['value' => 'Furniture', 'label' => __('Furniture')],
                ['value' => 'Furniture > Baby & Toddler Furniture',
                    'label' => __('Furniture > Baby & Toddler Furniture')],
                ['value' => 'Furniture > Beds & Accessories', 'label' => __('Furniture > Beds & Accessories')],
                ['value' => 'Furniture > Benches', 'label' => __('Furniture > Benches')],
                ['value' => 'Furniture > Cabinets & Storage', 'label' => __('Furniture > Cabinets & Storage')],
                ['value' => 'Furniture > Carts & Islands', 'label' => __('Furniture > Carts & Islands')],
                ['value' => 'Furniture > Chair Accessories', 'label' => __('Furniture > Chair Accessories')],
                ['value' => 'Furniture > Chairs', 'label' => __('Furniture > Chairs')],
                ['value' => 'Furniture > Entertainment Centers & TV Stands',
                    'label' => __('Furniture > Entertainment Centers & TV Stands')],
                ['value' => 'Furniture > Furniture Sets', 'label' => __('Furniture > Furniture Sets')],
                ['value' => 'Furniture > Futon Frames', 'label' => __('Furniture > Futon Frames')],
                ['value' => 'Furniture > Futon Pads', 'label' => __('Furniture > Futon Pads')],
                ['value' => 'Furniture > Futons', 'label' => __('Furniture > Futons')],
                ['value' => 'Furniture > Office Furniture', 'label' => __('Furniture > Office Furniture')],
                ['value' => 'Furniture > Office Furniture Accessories',
                    'label' => __('Furniture > Office Furniture Accessories')],
                ['value' => 'Furniture > Ottomans', 'label' => __('Furniture > Ottomans')],
                ['value' => 'Furniture > Outdoor Furniture', 'label' => __('Furniture > Outdoor Furniture')],
                ['value' => 'Furniture > Outdoor Furniture Accessories',
                    'label' => __('Furniture > Outdoor Furniture Accessories')],
                ['value' => 'Furniture > Room Divider Accessories',
                    'label' => __('Furniture > Room Divider Accessories')],
                ['value' => 'Furniture > Room Dividers', 'label' => __('Furniture > Room Dividers')],
                ['value' => 'Furniture > Shelving', 'label' => __('Furniture > Shelving')],
                ['value' => 'Furniture > Shelving Accessories', 'label' => __('Furniture > Shelving Accessories')],
                ['value' => 'Furniture > Sofa Accessories', 'label' => __('Furniture > Sofa Accessories')],
                ['value' => 'Furniture > Sofas', 'label' => __('Furniture > Sofas')],
                ['value' => 'Furniture > Table Accessories', 'label' => __('Furniture > Table Accessories')],
                ['value' => 'Furniture > Tables', 'label' => __('Furniture > Tables')],
                ['value' => 'Hardware', 'label' => __('Hardware')],
                ['value' => 'Hardware > Building Consumables', 'label' => __('Hardware > Building Consumables')],
                ['value' => 'Hardware > Building Materials', 'label' => __('Hardware > Building Materials')],
                ['value' => 'Hardware > Fencing & Barriers', 'label' => __('Hardware > Fencing & Barriers')],
                ['value' => 'Hardware > Fuel', 'label' => __('Hardware > Fuel')],
                ['value' => 'Hardware > Fuel Containers & Tanks', 'label' => __('Hardware > Fuel Containers & Tanks')],
                ['value' => 'Hardware > Hardware Accessories', 'label' => __('Hardware > Hardware Accessories')],
                ['value' => 'Hardware > Hardware Pumps', 'label' => __('Hardware > Hardware Pumps')],
                ['value' => 'Hardware > Heating, Ventilation & Air Conditioning',
                    'label' => __('Hardware > Heating, Ventilation & Air Conditioning')],
                ['value' => 'Hardware > Locks & Keys', 'label' => __('Hardware > Locks & Keys')],
                ['value' => 'Hardware > Plumbing', 'label' => __('Hardware > Plumbing')],
                ['value' => 'Hardware > Power & Electrical Supplies',
                    'label' => __('Hardware > Power & Electrical Supplies')],
                ['value' => 'Hardware > Small Engines', 'label' => __('Hardware > Small Engines')],
                ['value' => 'Hardware > Storage Tanks', 'label' => __('Hardware > Storage Tanks')],
                ['value' => 'Hardware > Tool Accessories', 'label' => __('Hardware > Tool Accessories')],
                ['value' => 'Hardware > Tools', 'label' => __('Hardware > Tools')],
                ['value' => 'Health & Beauty', 'label' => __('Health & Beauty')],
                ['value' => 'Health & Beauty > Health Care', 'label' => __('Health & Beauty > Health Care')],
                ['value' => 'Health & Beauty > Jewelry Cleaning & Care',
                    'label' => __('Health & Beauty > Jewelry Cleaning & Care')],
                ['value' => 'Health & Beauty > Personal Care', 'label' => __('Health & Beauty > Personal Care')],
                ['value' => 'Home & Garden', 'label' => __('Home & Garden')],
                ['value' => 'Home & Garden > Bathroom Accessories',
                    'label' => __('Home & Garden > Bathroom Accessories')],
                ['value' => 'Home & Garden > Business & Home Security',
                    'label' => __('Home & Garden > Business & Home Security')],
                ['value' => 'Home & Garden > Decor', 'label' => __('Home & Garden > Decor')],
                ['value' => 'Home & Garden > Emergency Preparedness',
                    'label' => __('Home & Garden > Emergency Preparedness')],
                ['value' => 'Home & Garden > Fireplace & Wood Stove Accessories',
                    'label' => __('Home & Garden > Fireplace & Wood Stove Accessories')],
                ['value' => 'Home & Garden > Fireplaces', 'label' => __('Home & Garden > Fireplaces')],
                ['value' => 'Home & Garden > Flood, Fire & Gas Safety',
                    'label' => __('Home & Garden > Flood, Fire & Gas Safety')],
                ['value' => 'Home & Garden > Household Appliance Accessories',
                    'label' => __('Home & Garden > Household Appliance Accessories')],
                ['value' => 'Home & Garden > Household Appliances',
                    'label' => __('Home & Garden > Household Appliances')],
                ['value' => 'Home & Garden > Household Supplies', 'label' => __('Home & Garden > Household Supplies')],
                ['value' => 'Home & Garden > Kitchen & Dining', 'label' => __('Home & Garden > Kitchen & Dining')],
                ['value' => 'Home & Garden > Lawn & Garden', 'label' => __('Home & Garden > Lawn & Garden')],
                ['value' => 'Home & Garden > Lighting', 'label' => __('Home & Garden > Lighting')],
                ['value' => 'Home & Garden > Lighting Accessories',
                    'label' => __('Home & Garden > Lighting Accessories')],
                ['value' => 'Home & Garden > Linens & Bedding', 'label' => __('Home & Garden > Linens & Bedding')],
                ['value' => 'Home & Garden > Parasols & Rain Umbrellas',
                    'label' => __('Home & Garden > Parasols & Rain Umbrellas')],
                ['value' => 'Home & Garden > Plants', 'label' => __('Home & Garden > Plants')],
                ['value' => 'Home & Garden > Pool & Spa', 'label' => __('Home & Garden > Pool & Spa')],
                ['value' => 'Home & Garden > Smoking Accessories',
                    'label' => __('Home & Garden > Smoking Accessories')],
                ['value' => 'Home & Garden > Umbrella Sleeves & Cases',
                    'label' => __('Home & Garden > Umbrella Sleeves & Cases')],
                ['value' => 'Home & Garden > Wood Stoves', 'label' => __('Home & Garden > Wood Stoves')],
                ['value' => 'Luggage & Bags', 'label' => __('Luggage & Bags')],
                ['value' => 'Luggage & Bags > Backpacks', 'label' => __('Luggage & Bags > Backpacks')],
                ['value' => 'Luggage & Bags > Briefcases', 'label' => __('Luggage & Bags > Briefcases')],
                ['value' => 'Luggage & Bags > Cosmetic & Toiletry Bags',
                    'label' => __('Luggage & Bags > Cosmetic & Toiletry Bags')],
                ['value' => 'Luggage & Bags > Diaper Bags', 'label' => __('Luggage & Bags > Diaper Bags')],
                ['value' => 'Luggage & Bags > Dry Boxes', 'label' => __('Luggage & Bags > Dry Boxes')],
                ['value' => 'Luggage & Bags > Duffel Bags', 'label' => __('Luggage & Bags > Duffel Bags')],
                ['value' => 'Luggage & Bags > Fanny Packs', 'label' => __('Luggage & Bags > Fanny Packs')],
                ['value' => 'Luggage & Bags > Garment Bags', 'label' => __('Luggage & Bags > Garment Bags')],
                ['value' => 'Luggage & Bags > Luggage Accessories',
                    'label' => __('Luggage & Bags > Luggage Accessories')],
                ['value' => 'Luggage & Bags > Messenger Bags', 'label' => __('Luggage & Bags > Messenger Bags')],
                ['value' => 'Luggage & Bags > Shopping Totes', 'label' => __('Luggage & Bags > Shopping Totes')],
                ['value' => 'Luggage & Bags > Suitcases', 'label' => __('Luggage & Bags > Suitcases')],
                ['value' => 'Luggage & Bags > Train Cases', 'label' => __('Luggage & Bags > Train Cases')],
                ['value' => 'Mature', 'label' => __('Mature')],
                ['value' => 'Mature > Erotic', 'label' => __('Mature > Erotic')],
                ['value' => 'Mature > Weapons', 'label' => __('Mature > Weapons')],
                ['value' => 'Media', 'label' => __('Media')],
                ['value' => 'Media > Books', 'label' => __('Media > Books')],
                ['value' => 'Media > Carpentry & Woodworking Project Plans',
                    'label' => __('Media > Carpentry & Woodworking Project Plans')],
                ['value' => 'Media > DVDs & Videos', 'label' => __('Media > DVDs & Videos')],
                ['value' => 'Media > Magazines & Newspapers', 'label' => __('Media > Magazines & Newspapers')],
                ['value' => 'Media > Music & Sound Recordings', 'label' => __('Media > Music & Sound Recordings')],
                ['value' => 'Media > Product Manuals', 'label' => __('Media > Product Manuals')],
                ['value' => 'Media > Sheet Music', 'label' => __('Media > Sheet Music')],
                ['value' => 'Office Supplies', 'label' => __('Office Supplies')],
                ['value' => 'Office Supplies > Book Accessories', 'label' => __('Office Supplies > Book Accessories')],
                ['value' => 'Office Supplies > Desk Pads & Blotters',
                    'label' => __('Office Supplies > Desk Pads & Blotters')],
                ['value' => 'Office Supplies > Filing & Organization',
                    'label' => __('Office Supplies > Filing & Organization')],
                ['value' => 'Office Supplies > General Office Supplies',
                    'label' => __('Office Supplies > General Office Supplies')],
                ['value' => 'Office Supplies > Impulse Sealers', 'label' => __('Office Supplies > Impulse Sealers')],
                ['value' => 'Office Supplies > Lap Desks', 'label' => __('Office Supplies > Lap Desks')],
                ['value' => 'Office Supplies > Name Plates', 'label' => __('Office Supplies > Name Plates')],
                ['value' => 'Office Supplies > Office & Chair Mats',
                    'label' => __('Office Supplies > Office & Chair Mats')],
                ['value' => 'Office Supplies > Office Carts', 'label' => __('Office Supplies > Office Carts')],
                ['value' => 'Office Supplies > Office Equipment', 'label' => __('Office Supplies > Office Equipment')],
                ['value' => 'Office Supplies > Office Instruments',
                    'label' => __('Office Supplies > Office Instruments')],
                ['value' => 'Office Supplies > Paper Handling', 'label' => __('Office Supplies > Paper Handling')],
                ['value' => 'Office Supplies > Presentation Supplies',
                    'label' => __('Office Supplies > Presentation Supplies')],
                ['value' => 'Office Supplies > Shipping Supplies',
                    'label' => __('Office Supplies > Shipping Supplies')],
                ['value' => 'Religious & Ceremonial', 'label' => __('Religious & Ceremonial')],
                ['value' => 'Religious & Ceremonial > Memorial Ceremony Supplies',
                    'label' => __('Religious & Ceremonial > Memorial Ceremony Supplies')],
                ['value' => 'Religious & Ceremonial > Religious Items',
                    'label' => __('Religious & Ceremonial > Religious Items')],
                ['value' => 'Religious & Ceremonial > Wedding Ceremony Supplies',
                    'label' => __('Religious & Ceremonial > Wedding Ceremony Supplies')],
                ['value' => 'Software', 'label' => __('Software')],
                ['value' => 'Software > Computer Software', 'label' => __('Software > Computer Software')],
                ['value' => 'Software > Digital Goods & Currency',
                    'label' => __('Software > Digital Goods & Currency')],
                ['value' => 'Software > Video Game Software', 'label' => __('Software > Video Game Software')],
                ['value' => 'Sporting Goods', 'label' => __('Sporting Goods')],
                ['value' => 'Sporting Goods > Athletics', 'label' => __('Sporting Goods > Athletics')],
                ['value' => 'Sporting Goods > Exercise & Fitness',
                    'label' => __('Sporting Goods > Exercise & Fitness')],
                ['value' => 'Sporting Goods > Indoor Games', 'label' => __('Sporting Goods > Indoor Games')],
                ['value' => 'Sporting Goods > Outdoor Recreation',
                    'label' => __('Sporting Goods > Outdoor Recreation')],
                ['value' => 'Toys & Games', 'label' => __('Toys & Games')],
                ['value' => 'Toys & Games > Game Timers', 'label' => __('Toys & Games > Game Timers')],
                ['value' => 'Toys & Games > Games', 'label' => __('Toys & Games > Games')],
                ['value' => 'Toys & Games > Outdoor Play Equipment',
                    'label' => __('Toys & Games > Outdoor Play Equipment')],
                ['value' => 'Toys & Games > Puzzles', 'label' => __('Toys & Games > Puzzles')],
                ['value' => 'Toys & Games > Toys', 'label' => __('Toys & Games > Toys')],
                ['value' => 'Vehicles & Parts', 'label' => __('Vehicles & Parts')],
                ['value' => 'Vehicles & Parts > Vehicle Parts & Accessories',
                    'label' => __('Vehicles & Parts > Vehicle Parts & Accessories')],
                ['value' => 'Vehicles & Parts > Vehicles', 'label' => __('Vehicles & Parts > Vehicles')],
            ];
        }
        return $this->_options;
    }
}
