<?php declare(strict_types=1);

namespace Rvvup\Payments\Block\Adminhtml;

use Magento\Backend\Block\Template\Context;
use Magento\Config\Block\System\Config\Form\Field;
use Magento\Framework\Data\Form\Element\AbstractElement;
use Magento\Framework\Exception\LocalizedException;
use Magento\Store\Model\Store;

class CredentialValidator extends Field
{
    /**
     * @inheritDoc
     */
    protected function _renderScopeLabel(AbstractElement $element): string
    {
        // Return empty label
        return '';
    }

    /**
     * @inheritDoc
     * @throws LocalizedException
     */
    protected function _getElementHtml(AbstractElement $element): string
    {
        // Replace field markup with validation button
        $title = __('Validate Credentials');
        $storeId = 0;

        if ($this->getRequest()->getParam('website')) {
            $website = $this->_storeManager->getWebsite($this->getRequest()->getParam('website'));
            if ($website->getId()) {
                /** @var Store $store */
                $store = $website->getDefaultStore();
                $storeId = $store->getStoreId();
            }
        }

        $endpoint = $this->getUrl('rvvup/credential/validate', ['storeId' => $storeId]);

        $html = <<<TEXT
            <button
                type="button"
                id="rvvup_validate_credentials"
                title="{$title}"
                class="button"
                onclick="rvvupValidator.call(this, '{$endpoint}')"
                disabled="true">
                <span>{$title}</span>
            </button>
TEXT;

        return $html;
    }
}
