<?php
namespace Expedux\Predownloads\Block;

class HomeSearch extends \Magento\Framework\View\Element\Template
{
	public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\App\ResourceConnection $resource,
        \Smartwave\Dailydeals\Model\DailydealFactory $dailydealFactory
    )
    {   
        $this->_resource = $resource;
        $this->dailydealFactory=$dailydealFactory;   
        parent::__construct($context);
    }
    public function getCourcesSearch()
    {
        $connection = $this->_resource->getConnection();
	    $select = 'SELECT course_names_id, title, link FROM search_course_names WHERE status=1 ORDER BY sort_order';
        return $connection->fetchAll($select);                        
    }
    public function getCourcesTypes()
    {
        $connection = $this->_resource->getConnection();
        $select = "SELECT course_types_id, title FROM search_course_types where course_names_id = 1 AND status = 1 ORDER BY sort_order";
        return $connection->fetchAll($select);                        
    }
    // @return Productcollection whose status is enabled
    public function getDailydealEnableProduct()
    {
        $collection=$this->dailydealFactory->create()->getCollection();
        $collection->addFieldToSelect('*');
        $collection->addFieldToFilter('sw_deal_enable', ['eq' => 1]);
        return $collection;
    }
    public function getFormActionUrl()
    {
        return $this->getUrl('predownloads/download/courseredirect');
    }    
}
