<?php
	namespace Expedux\Predownloads\Controller\Adminhtml\Category;
	use Expedux\Predownloads\Model\CategoryFactory as CategoryFactory;

	class Resource extends \Expedux\Predownloads\Controller\Adminhtml\Category
	{
		
		public function __construct(
			\Magento\Framework\View\Result\LayoutFactory $resultLayoutFactory,
			\Magento\Framework\Registry $registry,
			\Magento\Backend\App\Action\Context $context,
			CategoryFactory $categoryFactory
		) {
			$this->resultLayoutFactory = $resultLayoutFactory;
			parent::__construct($registry,$categoryFactory, $context);
		}

		/**
		 * @return \Magento\Framework\View\Result\Layout
		 */
		public function execute()
		{
			$this->initCategory();
			$resultLayout = $this->resultLayoutFactory->create();
			$resourceBlock = $resultLayout->getLayout()->getBlock('category_edit_tab_resource');
			if ($resourceBlock) {
				$resourceBlock->setCategoryResources($this->getRequest()->getPost('category_resources', null));
			} 
			return $resultLayout;
		}

	}