<?php

namespace Expedux\Predownloads\Controller\Adminhtml;

use Magento\Backend\App\Action;
use Magento\Backend\App\Action\Context;
use Magento\Backend\Model\View\Result\RedirectFactory;
use \Expedux\Predownloads\Model\ResourceFactory;
use Magento\Framework\Registry;

abstract class Resource extends \Magento\Backend\App\Action
{
    /**
     * Company factory
     *
     * @var resourceFactory
     */
    protected $resourceFactory;

    /**
     * Core registry
     *
     * @var Registry
     */
    protected $coreRegistry;

    /**
     * @var RedirectFactory
     */
    protected $resultRedirectFactory;

    /**
     *
     * @param Registry $registry
     * @param resourceFactory $resourceFactory
     * @param Context $context
     */
    public function __construct(
        Registry $registry,
        ResourceFactory $resourceFactory,
        Context $context
    ) {

        $this->coreRegistry = $registry;
        $this->resourceFactory = $resourceFactory;
        $this->resultRedirectFactory = $context->getResultRedirectFactory();
        parent::__construct($context);
    }

    protected function initResource()
    {
        $companyId = $this->getRequest()->getParam('id');
        $company   = $this->resourceFactory->create();
        if ($companyId) {
            $company->getResource()->load($company, $companyId);
        }
        $this->coreRegistry->register('expedux_predownloads_resource', $company);
        return $company;
    }

    
    /**
     *
     * @param array $data
     * @return array
     */
    protected function filterData($data)
    {
        return $data;
    }
}
