<?php

namespace Expedux\Predownloads\Controller\Adminhtml\Resource;

use Magento\Framework\Controller\ResultFactory;

class Addnew extends \Magento\Backend\App\Action{
    
    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\Registry $coreRegistry,
        \Expedux\Predownloads\Model\ResourceFactory $resourceFactory
    ) {
        parent::__construct($context);
        $this->coreRegistry = $coreRegistry;
        $this->resourceFactory = $resourceFactory;
    }
    public function execute()
    {
        $rowId = (int) $this->getRequest()->getParam('id');
        $rowData = $this->resourceFactory->create();

        if($rowId){
            $rowData = $rowData->load($rowId);
            if(!$rowData->getId()){
                $this->messageManager->addError(__('Column not exist'));
                $this->_redirect('*/*/index');
                return;
            }
        }
        $this->coreRegistry->register('row_data', $rowData);
        $resultPage = $this->resultFactory->create(ResultFactory::TYPE_PAGE);
        $title = $rowId ? __('Edit Resource'): __('Add Resource');
        $resultPage->getConfig()->getTitle()->prepend($title);
       
        return $resultPage;
    }

}
