<?php

namespace Expedux\Predownloads\Controller\Index;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Expedux\Predownloads\Model\ResourceModel\Resource\CollectionFactory  as Resourcecollection;
use Magento\Customer\Model\Session as CustomerSession;
class Downhtml extends Action
{
    protected $_pageFactory;
    protected $postFactory;

    public function __construct(
        Context $context,
        Resourcecollection $resourceCollectionFactory,
        CustomerSession $customerSession,
        PageFactory $_pageFactory
    ) {
        $this->_pageFactory = $_pageFactory;
        $this->resource = $resourceCollectionFactory;
        $this->_customerSession = $customerSession;
        parent::__construct($context);
    }

    public function execute()
    {
        $id = $this->getRequest()->getPost('bid');
        $errmsg = "No data available";
        if (!empty($id)) {
            $resourcecollection = $this->resource->create()
            ->addFieldToFilter('resource_id', $id)
            ->addFieldToFilter('status', 1);
            if(!empty($resourcecollection->getData())){
                $resource_data = $resourcecollection->getData()[0];
                $this->setPageRequest($id, $resource_data['resource_title']);
                echo $resource_data['content'];
                exit();
            }
            else{
                echo $errmsg;
                exit();
            }
        }
        else{
            echo $errmsg;
            exit();
        }

    }
    public function setPageRequest($id, $pageRequest)
	{
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $resource = $objectManager->get('Magento\Framework\App\ResourceConnection');
        $connection = $resource->getConnection();
        $tableName = $resource->getTableName('predownloads_referer');     
        $checkReferersql = "SELECT COUNT(*) FROM " . $tableName . " WHERE email='".$this->_customerSession->getPredownloadEmail()."' AND page_request='".$pageRequest."'
        AND DATE(created_at) = CURDATE()";
        $checkRefererExist = $connection->fetchOne($checkReferersql);
        if($checkRefererExist == 0 )
        {
            $pageReferer = '';
            $reffsql = "INSERT INTO " . $tableName . " (email, page_request, referer, created_at) VALUES "
            . "('" . $this->_customerSession->getPredownloadEmail() . "', '" .$pageRequest . "', '" . $pageReferer . "', NOW())";
             $connection->query($reffsql); 
             return true;   
        }  
        return false;	
	}
}
