<?php

namespace Expedux\Predownloads\Controller\Index;

use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\App\Action\Action;

class Submit extends Action
{
    protected $resultPageFactory;

    public function __construct(
        Context $context,
        PageFactory $resultPageFactory,
        \Expedux\Predownloads\Model\PreDownloadsFactory $predownloadFactory,
        \Expedux\Predownloads\Model\ResourceFactory $resourceFactory,
        \Magento\Customer\Model\Session $customerSession
    )
    {
        $this->resultPageFactory = $resultPageFactory;
        $this->predownloadFactory = $predownloadFactory;
        $this->resourceFactory = $resourceFactory;
        $this->_customerSession = $customerSession;
        parent::__construct($context);
    }

    public function execute()
    {
        try {
            $data = (array)$this->getRequest()->getPost();           
            $preId = 0;
            if ($data) {                
                if($this->_customerSession->getPredownload())
                {
                    $predownloadId = $this->_customerSession->getPredownload();
                }
                
                $comm_preferences_arr = array();
			    if(!empty($this->getRequest()->getPost('comm_preferences'))) {
				foreach($this->getRequest()->getPost('comm_preferences') as $comm) {
					if($comm == 'Email') {
						$comm_preferences_arr[] = 'email';
					}
					if($comm == 'Phone') {
						$comm_preferences_arr[] = 'phone';
					}
					if($comm == 'IM') {
						$comm_preferences_arr[] = 'im';
					}
					if($comm == 'Post') {
						$comm_preferences_arr[] = 'post';
					}
				}
			}
			if(!empty($this->getRequest()->getPost('hear_us'))) {
				$comm_preferences_arr[] = 'approved_partners';
			}
			$comm_preferences_str = '';
			if(count($comm_preferences_arr) > 0)
			{
				$comm_preferences_str = implode(',', $comm_preferences_arr);
			}
            $predownloads = $this->predownloadFactory->create();
			$data['email'] = $data['post_content'];
			$data['telephone'] = $data['telephone'];
			$data['comm_preferences'] = $comm_preferences_str;
			$data['created_at'] = date('Y-m-d H:i:s');
            $data['status'] = 1;
            $predownloads->setData($data);                   
			if($predownloads->save())
        	{  
                    $this->_customerSession->setPredownload(1);
                    $this->_customerSession->setPredownloadEmail($data['email']);
                    $pageReferer = $this->_customerSession->getPredownloadReferer();
                    if(!empty($pageReferer))
                    { 
                        $page_request='';
                        if($predownloadId > 0)
                        {
                            $resourcecollection = $this->resource->create()
                            ->addFieldToFilter('resource_id', $id)
                            ->addFieldToFilter('status', 1);
                            if(!empty($resourcecollection->getData())){
                                $resource_data = $resourcecollection->getData()[0];
                                $page_request = $resource_data['resource_title']; 
                                $preId = $resource_data['resource_id'];
                            }
                        }  
                        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                        $resource = $objectManager->get('Magento\Framework\App\ResourceConnection');
                        $connection = $resource->getConnection();
                        $tableName = $resource->getTableName('predownloads_referer');
                        $reffsql = "INSERT INTO " . $tableName . " (email, page_request, referer, created_at) VALUES "
                    . "('" . $data['email'] . "', '" . $page_request . "', '" . $pageReferer . "', NOW())";
                        $connection->query($reffsql); 
                        $this->_customerSession->unsPredownloadReferer();                     
                    }
                /*Enable oro octive    
                //begin oro lead 
                $mainemail = $post['email'];       
                $orodetails = array ('firstname'  => $data['name'],
				         'hearAboutUs'  => $data['referer'],
			             'leadsources' => 'download',
						 'predownloadReferer' => 1);
			$comm_preferences = array();
			$inc = 0;
			$comm_preferences_id = 'contactcommunicationprefer71f420a4s';
		        if(!empty($this->getRequest()->getPost('comm_preferences'))){
                    foreach($this->getRequest()->getPost('comm_preferences') as $comm) {
                        if($comm == 'Email') {
                            $comm_preferences[$inc]['type'] = $comm_preferences_id;
                            $comm_preferences[$inc]['id'] = 'email';
                            $inc++;
                        }
                        if($comm == 'Phone') {
                            $comm_preferences[$inc]['type'] = $comm_preferences_id;
                            $comm_preferences[$inc]['id'] = 'phone';
                            $inc++;
                        }
                        if($comm == 'IM') {
                            $comm_preferences[$inc]['type'] = $comm_preferences_id;
                            $comm_preferences[$inc]['id'] = 'im';
                            $inc++;
                        }
                        if($comm == 'Post') {
                            $comm_preferences[$inc]['type'] = $comm_preferences_id;
                            $comm_preferences[$inc]['id'] = 'post';
                            $inc++;
                        }
                    }
		        }
                    if(!empty($this->getRequest()->getPost('hear_us'))){
                        $comm_preferences[$inc]['type'] = $comm_preferences_id;
                        $comm_preferences[$inc]['id'] = 'approved_partners';
                        $inc++;
                    }
                    if(!empty($comm_preferences)) { 
                        $orodetails ['comm_preferences'] = $comm_preferences;
                    }
                    if(!empty($this->getRequest()->getPost('tags'))) {
                    $orodetails ['telephone'] = $this->getRequest()->getPost('tags');
                    }
                    $predownloads->oroConnectContacts($orodetails, $mainemail);
                    //EOF oro Lead
                    //EOF Disabled*/
                    $this->messageManager->addSuccessMessage(__("Data Saved Successfully. Thank you"));
                }else{
                    $this->messageManager->addErrorMessage(__('Unable to submit your request. Please, try again later'));
                }
               
            }else
            {
                $this->messageManager->addErrorMessage(__('Unable to submit your request. Please, try again later'));
            }            
            if($preId > 0)
            {
                return $this->resultRedirectFactory->create()->setPath(
                    'predownloads/index/view',
                    [   
                        'id' => $preId,                         
                        '_secure' => $this->getRequest()->isSecure(),
                    ]
                );
                
            }
            else
            {
                return $this->resultRedirectFactory->create()->setPath(
                    'predownloads/index/index',
                    [                                        
                        '_secure' => $this->getRequest()->isSecure(),
                    ]
                );               
            }

        } catch (\Exception $e) {
            $this->messageManager->addErrorMessage($e, __("We can\'t submit your request, Please try again."));
        }       
        return $this->resultRedirectFactory->create()->setPath(
            'predownloads/index/form',
            [                                        
                '_secure' => $this->getRequest()->isSecure(),
            ]
        ); 
    }
}