<?php

namespace Expedux\Predownloads\Controller\Index;

use Magento\Framework\App\Action\Context;
use Magento\Framework\View\Result\PageFactory;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\App\Action\Action;
use Magento\Customer\Model\Session as CustomerSession;

class View extends Action
{
    protected $resultPageFactory;
    protected $postFactory;
    protected $_customerSession;

    public function __construct(
        Context $context,
        PageFactory $pageFactory,
        CustomerSession $customerSession,
        \Magento\Framework\App\Request\Http $request
    )
    {
        $this->_pageFactory = $pageFactory;
        $this->request = $request;
        $this->_customerSession = $customerSession;
        parent::__construct($context);
    }

    public function execute()
    {   //remove after complete
        /*$downid = $this->request->getParam('id');
        $this->_customerSession->setPredownloadId($downid);
        $this->_customerSession->setPredownloadReferer($downid);
        $this->_customerSession->setPredownloadEmail('suresh.g@expedux.com');
        $this->_customerSession->setPredownload(1);*/
        //EOD after complete
        if(!$this->_customerSession->getPredownload())
	    {
            if(isset($_SERVER['HTTP_REFERER']) && !empty($_SERVER['HTTP_REFERER'])) {

                if(!stristr($_SERVER['HTTP_REFERER'],'predownloads/index'))
                {
                    $downid = $this->request->getParam('id');                    
                    $this->_customerSession->setPredownloadReferer($_SERVER['HTTP_REFERER']);    
                    if($downid > 0) $this->_customerSession->setPredownloadId($downid);
    
                }
    
            }
            if ($this->request->getParam('id'))  {
                $id = $this->request->getParam('id');
                if($id > 0) $this->_customerSession->setPredownloadId($id);    
                $pageRefererQuery = $_SERVER["QUERY_STRING"];    
                if(!empty($pageRefererQuery)) $this->_customerSession->setPredownloadQstr($pageRefererQuery);
            }
            return $this->resultRedirectFactory->create()->setPath(
                'predownloads/index/form/',
                [                            
                    '_secure' => $this->getRequest()->isSecure(),
                ]
            );
        }

        if($this->_customerSession->getPredownload())
		{
            if(isset($_SERVER['HTTP_REFERER']) && !empty($_SERVER['HTTP_REFERER'])) 
            {
			$pageReferer=$_SERVER['HTTP_REFERER'];
			if(!stristr($pageReferer,'predownloads/index'))
			{
				$id = $this->request->getParam('id');
                if($id > 0) $this->_customerSession->setPredownloadId($id);
                
                $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                $resource = $objectManager->get('Magento\Framework\App\ResourceConnection');
                $connection = $resource->getConnection();
                $tableName = $resource->getTableName('predownloads_referer');
				$checkReferersql = "SELECT COUNT(*) FROM " . $tableName . " WHERE email='".$this->_customerSession->getPredownloadEmail()."' AND referer='".$pageReferer."'
                AND DATE(created_at) = CURDATE()";
                $checkRefererExist = $connection->fetchOne($checkReferersql);
                if($checkRefererExist == 0 )
				{
					$page_request='';
                    $predownloadId = $this->_customerSession->getPredownload();
					if($predownloadId > 0)
					{
                        $tableName = $resource->getTableName('expedux_predownloads_resources');
						$resourcesql= "SELECT resource_title FROM " . $tableName . " WHERE status=1 and resource_id='".(int)$predownloadId."'";
						$resourcestitle = $checkRefererExist = $connection->fetchOne($resourcesql);
                        $page_request = $resourcestitle;
                       
                    }
                    $tableName = $resource->getTableName('predownloads_referer');
					$reffsql = "INSERT INTO " . $tableName . " (email, page_request, referer, created_at) VALUES "
				   . "('" . $this->_customerSession->getPredownloadEmail() . "', '" . $page_request . "', '" . $pageReferer . "', NOW())";
                    $connection->query($reffsql);
					}
				}
			}

		}
        return $this->_pageFactory->create();
    }
}