<?php

namespace Expedux\ExamBookings\Block\Adminhtml\Bookings\Edit;

class Form extends \Magento\Backend\Block\Widget\Form\Generic
{
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Expedux\ExamBookings\Model\BookingStatus $options,
        \Expedux\ExamBookings\Model\Multidelegate $multidelegate,
        \Magento\Customer\Model\ResourceModel\Group\Collection $customerGroup,
        \Expedux\ExamBookings\Model\DropdownValues $examtypes,
        array $data = []
    ) {
        $this->_options = $options;
        $this->multidelegate = $multidelegate;
        $this->_customerGroup = $customerGroup; 
        $this->examtypes = $examtypes;
        parent::__construct($context, $registry, $formFactory, $data);
    }


    protected function _prepareForm()
    {
        
        $attachment = $this->getAttachment();
        $model = $this->_coreRegistry->registry('row_data');
        $form = $this->_formFactory->create(
            ['data' => [
                            'id' => 'edit_form',
                            'enctype' => 'multipart/form-data',
                            'action' => $this->getData('action'),
                            'method' => 'post'
                        ]
            ]
        );
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $orderId = '';
        if ($model->getId()) {
        
            $fieldset = $form->addFieldset(
                'base_fieldset',
                ['legend' => __('Bookings information'), 'class' => 'fieldset-wide']
            );
            $fieldset->addField('booking_id', 'hidden', ['name' => 'booking_id']);
            $custLastName = '';
            $custFirstName = $model->getDelegatesName();
            $orderuniqueid = $model->getOrderId();
            $delegatesEmail = $model->getDelegateEmail();
        } else {
            $orderId = $this->getRequest()->getParam('order_id');
            $order = $objectManager->create('\Magento\Sales\Model\OrderRepository')->get($orderId);
            $custLastName = $order->getCustomerLastname();
            $custFirstName = $order->getCustomerFirstname();
            $orderuniqueid = $order->getIncrementId();

            $shiperemail = $order->getShippingAddress()->getDelegateEmail();
				if(!empty($shiperemail)){
					$delegatesEmail = $shiperemail;
				}else{
					$delegatesEmail = $order->getShippingAddress()->getEmail();
                }
                
            $fieldset = $form->addFieldset(
                'base_fieldset',
                ['legend' => __('Bookings information'), 'class' => 'fieldset-wide']
            );
        }

        
        
        // Get Order Items
    if(!empty($orderId)){
        $fieldset->addField(
            'order_primary_id',
            'hidden',
            [
                'name' => 'order_primary_id',
                'label' => __('Order Primary Id'),
                'id' => 'order_primary_id',
                'title' => __('order_primary_id'),
                'class' => 'required-entry',
                'required' => true,
                'value' => $orderId,
            ]
        );
    }
        $fieldset->addField(
            'order_id',
            'text',
            [
                'name' => 'order_id',
                'label' => __('Order Id'),
                'id' => 'order_id',
                'title' => __('order_id'),
                'class' => 'required-entry',
                'required' => true,
                'value' => $orderuniqueid,
                'readonly'=>true
            ]
        );
        if (!$model->getId()) {
        $fieldset->addField(
            'is_multidelegate',
            'select',
            [
                'name' => 'is_multidelegate',
                'label' => __('Is Multidelegate'),
                'id' => 'is_multidelegate',
                'title' => __('is_multidelegate'),
                'values' => $this->multidelegate->getOptionArray(),
                'class' => 'is_multidelegate',
                'required' => true,
                
            ]
        );
    }
        
        $fieldset->addField(
            'delegates_name',
            'text',
            [
                'name' => 'delegates_name',
                'label' => __('Delegates Name'),
                'id' => 'delegates_name',
                'title' => __('delegates_name'),
                'class' => 'required-entry',
                'required' => true,
                'value' => $custFirstName.' '.$custLastName,
                'readonly'=>true,
                
            ]
        );
        $fieldset->addField(
            'delegates_email',
            'text',
            [
                'name' => 'delegates_email',
                'label' => __('Delegates Email'),
                'id' => 'delegates_email',
                'title' => __('delegates_email'),
                'class' => 'required-entry',
                'value' => $delegatesEmail,
                'required' => true,
            ]
        );
        if (!$model->getId()) {
        $fieldset->addField(
            'email_add_more',
            'button',
            [
                'name' => 'email_add_more',
                'id' => 'email_add_more',
                'title' => __('add_more'),
                'class' => 'required-entry',
                'value' => 'Add More',
                'type' => 'hidden'
            ]
        );
    }
        $fieldset->addField(
            'exam_date',
            'date',
            [
                'name' => 'exam_date',
                'label' => __('Exam Date'),
                'id' => 'exam_date',
                'title' => __('exam_date'),
                'class' => 'required-entry',
                'date_format' => 'yyyy-MM-dd',
            ]
        );
        $fieldset->addField(
            'exam_slot',
            'select',
            [
                'name' => 'exam_slot',
                'label' => __('Exam Slot'),
                'id' => 'exam_slot',
                'title' => __('exam_slot'),
                'class' => 'required-entry',
                'required' => true,
                'values' => $this->examtypes->getAllExamSlots()
            ]
        );
        $fieldset->addField(
            'exam_mode',
            'select',
            [
                'name' => 'exam_mode',
                'label' => __('Exam Mode'),
                'id' => 'exam_mode',
                'title' => __('exam_mode'),
                'class' => 'required-entry',
                'required' => true,
                'values' => $this->examtypes->getAllExamMode()
            ]
        );
        $fieldset->addField(
            'exam_types',
            'select',
            [
                'name' => 'exam_types',
                'label' => __('Exam Types'),
                'id' => 'exam_types',
                'title' => __('exam_types'),
                'class' => 'required-entry',
                'required' => true,
                'values' => $this->examtypes->getAllExamTypes()
            ]
        );
        $fieldset->addField(
            'apmg_id',
            'text',
            [
                'name' => 'apmg_id',
                'label' => __('APMG Booking ID'),
                'id' => 'apmg_id',
                'title' => __('apmg_id'),
                'class' => 'required-entry',
                'required' => true,
            ]
        );
        $fieldset->addField(
            'apmg_invoice',
            'text',
            [
                'name' => 'apmg_invoice',
                'label' => __('APMG Invoice'),
                'id' => 'apmg_invoice',
                'title' => __('apmg_invoice'),
                'class' => 'required-entry',
                'required' => true,
            ]
        );
        $fieldset->addField(
            'course_sku',
            'text',
            [
                'name' => 'course_sku',
                'label' => __('Course SKU'),
                'id' => 'course_sku',
                'title' => __('course_sku'),
                'class' => 'required-entry',
                'required' => true,
            ]
        );
        $fieldset->addField(
            'candidate_no',
            'text',
            [
                'name' => 'candidate_no',
                'label' => __('Candidate No'),
                'id' => 'candidate_no',
                'title' => __('candidate_no'),
                'class' => 'required-entry',
                'required' => true,
            ]
        );
        $fieldset->addField(
            'request_date',
            'date',
            [
                'name' => 'request_date',
                'label' => __('Request Date'),
                'id' => 'request_date',
                'title' => __('request_date'),
                'class' => 'required-entry',
                'date_format' => 'yyyy-MM-dd',
            ]
        );
        $fieldset->addField(
            'status',
            'select',
            [
                'name' => 'status',
                'label' => __('Status'),
                'id' => 'status',
                'title' => __('Status'),
                'values' => $this->_options->getOptionArray(),
                'class' => 'status',
                'required' => true,
            ]
        );
        $fieldset->addField(
            'customer_comments',
            'textarea',
            [
                'name' => 'customer_comments',
                'label' => __('Customer Comments'),
                'id' => 'customer_comments',
                'title' => __('customer_comments'),
                'class' => 'required-entry',
                'required' => true,
            ]
        );
        
        
        if ($model->getId()) {
        $form->setValues($model->getData());
        }else{
        $form->addValues(array());
        }
        
        $form->setUseContainer(true);
        $this->setForm($form);

        return parent::_prepareForm();
    }
    /**
     * Get customer groups
     * 
     * @return array
     */ 
    public function getCustomerGroups() {
        $customerGroups = $this->_customerGroup->toOptionArray();
        array_unshift($customerGroups, array('value'=>'', 'label'=>'Any'));
        return $customerGroups;
    }
    /**
     * Get maximum upload size message
     *
     * @return \Magento\Framework\Phrase
     */
    public function getMaxUploadSizeMessage()
    {
        $maxFileSize = $this->fileSize->getMaxFileSizeInMb();
        if ($maxFileSize) {
            $message = __('The maximum file size limit is %1M.', $maxFileSize);
        } else {
            $message = __('We can\'t provide the upload settings right now.');
        }
        return $message;
    }
}
