<?php

namespace Expedux\ExamBookings\Controller\Adminhtml\Bookings;
use Magento\Framework\App\Filesystem\DirectoryList;
use Magento\MediaStorage\Model\File\UploaderFactory;
use Magento\Framework\Filesystem;
class Save extends \Magento\Backend\App\Action
{
    protected $uploaderFactory;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Expedux\ExamBookings\Model\BookingsFactory $bookingsFactory,
        Filesystem $fileSystem,
        UploaderFactory $uploaderFactory 
    ) {
        parent::__construct($context);
        $this->bookingsFactory = $bookingsFactory;
        $this->uploaderFactory = $uploaderFactory; 
        $this->fileSystem = $fileSystem;
    }


    public function execute()
    {  

        $data = $this->getRequest()->getPostValue();
        
        if (!$data) {
            $this->_redirect('*/*/addnew');
            return;
        }
        try { 
            
            $rowData = $this->bookingsFactory->create();

            $values = $rowData->getCollection();
                        if(isset($data['booking_id'])){
                            $values->addFieldToFilter('booking_id',['neq'=> $data['booking_id']]);
                        }
                    $values->addFieldToFilter('delegates_email',['eq'=> $data['delegates_email']]);

            if(!$values->getSize())
            {
                if (isset($data ['is_multidelegate']) && $data ['is_multidelegate'] == 1) {
                    $tcon = $data ['delegates_count'];						
                    for($m=0; $m <= $tcon; $m++)
                    {
                        if($m == 0)
                        {
                            $mdelegates_name = $data ['delegates_name'];
                            $mdelegates_email = $data ['delegates_email'];
                        }
                        else
                        {
                            $mdelegates_name = $data ['delegates_name'.$m];
                            $mdelegates_email = $data ['delegates_email'.$m];
                        }
                      if (!empty ( $mdelegates_name ) && !empty ( $mdelegates_email )) {
                          $data ['delegates_name'] = $mdelegates_name;
                          $data ['delegates_email'] = $mdelegates_email;						  	
                          
                          $rowData->setData ( $data );
                          $rowData->save ();
                      }			
                    }	
                    
                }else{
                    $rowData->setData($data);
                    $rowData->save();
                }
                    $this->messageManager->addSuccess(__('Booking has been successfully saved.'));
                    $this->_redirect('*/*/index');
            }else{
                $this->messageManager->addError(__('Booking already is there.'));
                if($this->_request->getParam('booking_id')){
                    $this->_redirect('*/*/addnew', ['booking_id' => $this->_request->getParam('booking_id'),'order_id' => $data['order_primary_id']]);
                }else{
                    $this->_redirect('*/*/addnew', ['booking_id' => $this->_request->getParam('booking_id'),'order_id' => $data['order_primary_id']]);
                }
            }
            
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
            $this->_redirect('*/*/index');
        }
       
    }
}
