<?php

namespace Expedux\ExamBookings\Controller\Adminhtml\Dropdown;

class Save extends \Magento\Backend\App\Action
{

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Expedux\ExamBookings\Model\DropdownFactory $dropdownFactory
    ) {
        parent::__construct($context);
        $this->dropdownFactory = $dropdownFactory;
    }


    public function execute()
    {  
        $data = $this->getRequest()->getPostValue();
        if (!$data) {
            $this->_redirect('*/*/addnew');
            return;
        }
        try { 
            
            $rowData = $this->dropdownFactory->create();

            $values = $rowData->getCollection();
                        if(isset($data['dropdown_id'])){
                            $values->addFieldToFilter('dropdown_id',['neq'=> $data['dropdown_id']]);
                        }
                    $values->addFieldToFilter('dropdown_name',['eq'=> $data['dropdown_name']]);

            if(!$values->getSize())
            {
                    $rowData->setData($data);
                    $rowData->save();
                    $this->messageManager->addSuccess(__('Dropdown value has been successfully saved.'));
                    $this->_redirect('*/*/index');
            }else{
                $this->messageManager->addError(__('Dropdown value already is there.'));
                if($this->_request->getParam('dropdown_id')){
                    $this->_redirect('*/*/addnew', ['dropdown_id' => $this->_request->getParam('dropdown_id')]);
                }else{
                    $this->_redirect('*/*/addnew');  
                }
            }
          

            
        } catch (\Exception $e) {
            $this->messageManager->addError(__($e->getMessage()));
            $this->_redirect('*/*/index');
        }
       
    }

}
