<?php
namespace Magento\Checkout\Api\Data;

/**
 * Extension class for @see \Magento\Checkout\Api\Data\ShippingInformationInterface
 */
class ShippingInformationExtension extends \Magento\Framework\Api\AbstractSimpleObject implements ShippingInformationExtensionInterface
{
    /**
     * @return string|null
     */
    public function getDelegateEmail()
    {
        return $this->_get('delegate_email');
    }

    /**
     * @param string $delegateEmail
     * @return $this
     */
    public function setDelegateEmail($delegateEmail)
    {
        $this->setData('delegate_email', $delegateEmail);
        return $this;
    }

    /**
     * @return \Magento\Quote\Api\Data\AddressInterface[]|null
     */
    public function getMultishippingAddress()
    {
        return $this->_get('multishipping_address');
    }

    /**
     * @param \Magento\Quote\Api\Data\AddressInterface[] $multishippingAddress
     * @return $this
     */
    public function setMultishippingAddress($multishippingAddress)
    {
        $this->setData('multishipping_address', $multishippingAddress);
        return $this;
    }

    /**
     * @return \Expedux\Checkout\Api\Data\DiscountBreakdownLineInterface[]|null
     */
    public function getMultishippingItems()
    {
        return $this->_get('multishipping_items');
    }

    /**
     * @param \Expedux\Checkout\Api\Data\DiscountBreakdownLineInterface[] $multishippingItems
     * @return $this
     */
    public function setMultishippingItems($multishippingItems)
    {
        $this->setData('multishipping_items', $multishippingItems);
        return $this;
    }
}
