<?php
namespace Magento\Checkout\Api\Data;

/**
 * ExtensionInterface class for @see \Magento\Checkout\Api\Data\ShippingInformationInterface
 */
interface ShippingInformationExtensionInterface extends \Magento\Framework\Api\ExtensionAttributesInterface
{
    /**
     * @return string|null
     */
    public function getDelegateEmail();

    /**
     * @param string $delegateEmail
     * @return $this
     */
    public function setDelegateEmail($delegateEmail);

    /**
     * @return \Magento\Quote\Api\Data\AddressInterface[]|null
     */
    public function getMultishippingAddress();

    /**
     * @param \Magento\Quote\Api\Data\AddressInterface[] $multishippingAddress
     * @return $this
     */
    public function setMultishippingAddress($multishippingAddress);

    /**
     * @return \Expedux\Checkout\Api\Data\DiscountBreakdownLineInterface[]|null
     */
    public function getMultishippingItems();

    /**
     * @param \Expedux\Checkout\Api\Data\DiscountBreakdownLineInterface[] $multishippingItems
     * @return $this
     */
    public function setMultishippingItems($multishippingItems);
}
