<?php
namespace Magento\Customer\Api\Data;

/**
 * Extension class for @see \Magento\Customer\Api\Data\AddressInterface
 */
class AddressExtension extends \Magento\Framework\Api\AbstractSimpleObject implements AddressExtensionInterface
{
    /**
     * @return string|null
     */
    public function getDelegateEmail()
    {
        return $this->_get('delegate_email');
    }

    /**
     * @param string $delegateEmail
     * @return $this
     */
    public function setDelegateEmail($delegateEmail)
    {
        $this->setData('delegate_email', $delegateEmail);
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSuccess()
    {
        return $this->_get('success');
    }

    /**
     * @param string $success
     * @return $this
     */
    public function setSuccess($success)
    {
        $this->setData('success', $success);
        return $this;
    }
}
